# -*- coding: utf-8 -*-
"""
Created on Tue Oct 26 21:38:56 2021

@author: alice
"""

from random import randint

class Monstre:
    def __init__(self,nom,hab,end,phrase_attaque,fuite="",particularite=None):
        self.__nom=nom
        self.__habilite=hab
        self.__endurance=end
        
        self.__phrase_attaque=phrase_attaque
        self.__fuite=fuite
        self.__particularite=particularite
        
        self.__puissance_attaque=0
        
        
        
    ############ GETTER #############
    
    def get_nom(self):
        return self.__nom
    
    def get_hab(self):
        return self.__habilite
    
    def get_end(self):
        return self.__endurance
    
    def est_mort(self):
        return self.__endurance<=0
    
    
    
    def attaque(self):
        return self.__phrase_attaque[randint(0,len(self.__phrase_attaque)-1)]
    
    def fait_fuire(self):
        return self.__fuite
    
    def get_part(self):
        return self.__particularite
    
    def get_power(self):
        return self.__puissance_attaque
    
    
    
    
    
    ############ SETTER #############
    
    
    def nouveau(self, nom, hab, end, phrase_attaque, fuite="", particularite=None):
        """rénitialise tous les attributs du monstre """
        self.__nom=nom
        self.__habilite=hab
        self.__endurance=end
        
        self.__phrase_attaque = phrase_attaque
        self.__fuite=fuite
        self.__particularite = particularite
        
        self.__puissance_attaque=0
        
    
    def blesser(self,x):
        assert type(x)==int
        self.__endurance -= x
        
    def random_power(self):
        self.__puissance_attaque = randint(1,6) + randint(1,6) + self.__habilite
        return self.__puissance_attaque
    
    
    
    
    
    ####### méthodes spéciales ########
    
    def __str__(self):
        return "\n\n        nom : {}\n        habilite : {}\n        endurance : {}\n        particularité : {}\n\n".format(self.__nom,self.__habilite,self.__endurance,self.__particularite)
    
    def __repr__(self):
        return "Monstre()"
    
    def __lt__(self,other):
        return self.__puissance_attaque < other.get_power()
    
    def __gt__(self,other):
        return self.__puissance_attaque > other.get_power()